/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.every_compat.WoodGood;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.block_set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.selene.resourcepack.DynamicDataPack;
import net.mehvahdjukaar.selene.resourcepack.EarlyPackReloadEvent;
import net.mehvahdjukaar.selene.resourcepack.recipe.IRecipeTemplate;
import net.mehvahdjukaar.selene.resourcepack.recipe.TemplateRecipeManager;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class CustomRecipeLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final int PATH_SUFFIX_LENGTH = ".json".length();

    private CustomRecipeLoader() {
        super(GSON, "template_recipes");
    }

    public static void onEarlyPackLoad(EarlyPackReloadEvent event) {
        ResourceManager manager = event.getManager();
        HashMap map = Maps.newHashMap();
        String directory = "template_recipes";
        int i = directory.length() + 1;
        for (ResourceLocation resourcelocation : manager.m_6540_(directory, s -> s.endsWith(".json"))) {
            String s2 = resourcelocation.m_135815_();
            ResourceLocation location = new ResourceLocation(resourcelocation.m_135827_(), s2.substring(i, s2.length() - PATH_SUFFIX_LENGTH));
            try {
                Resource resource = manager.m_142591_(resourcelocation);
                try {
                    InputStream inputstream = resource.m_6679_();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                        JsonElement jsonelement = (JsonElement)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class);
                        if (jsonelement != null) {
                            JsonElement put = map.put(location, jsonelement);
                            if (put == null) continue;
                            throw new IllegalStateException("Duplicate data file ignored with ID " + location);
                        }
                        WoodGood.LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)location, (Object)resourcelocation);
                    }
                    finally {
                        if (inputstream == null) continue;
                        inputstream.close();
                    }
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                WoodGood.LOGGER.error("Couldn't parse data file {} from {}", (Object)location, (Object)resourcelocation, (Object)exception);
            }
        }
        CustomRecipeLoader.loadRecipes(map);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        CustomRecipeLoader.loadRecipes(jsons);
    }

    private static void loadRecipes(Map<ResourceLocation, JsonElement> jsons) {
        int added = 0;
        boolean oldStatus = ((DynamicDataPack)WoodGood.SERVER_RESOURCES.getPack()).generateDebugResources;
        ((DynamicDataPack)WoodGood.SERVER_RESOURCES.getPack()).generateDebugResources = true;
        for (Map.Entry<ResourceLocation, JsonElement> j : jsons.entrySet()) {
            try {
                JsonElement jsonElement = j.getValue();
                if (!(jsonElement instanceof JsonObject)) continue;
                JsonObject jo = (JsonObject)jsonElement;
                IRecipeTemplate template = TemplateRecipeManager.read((JsonObject)jo);
                boolean ad = false;
                for (WoodType w : WoodTypeRegistry.WOOD_TYPES.values()) {
                    if (w == WoodType.OAK_WOOD_TYPE) continue;
                    ResourceLocation res = WoodGood.res(w.getAppendableId() + j.getKey().m_135815_());
                    FinishedRecipe newR = template.createSimilar((BlockType)WoodType.OAK_WOOD_TYPE, (BlockType)w, w.planks.m_5456_(), res.toString());
                    ((DynamicDataPack)WoodGood.SERVER_RESOURCES.getPack()).addRecipe(newR);
                    if (ad) continue;
                    ad = true;
                    ++added;
                }
            }
            catch (Exception e) {
                WoodGood.LOGGER.warn("Failed to add custom recipe for wood types. Be sure it is based off oak wood:", (Throwable)e);
            }
        }
        ((DynamicDataPack)WoodGood.SERVER_RESOURCES.getPack()).generateDebugResources = oldStatus;
        if (added != 0) {
            WoodGood.LOGGER.info("Added {} Custom Recipes for all {} wood types", (Object)added, (Object)WoodTypeRegistry.WOOD_TYPES.size());
        }
    }
}

